import type { App } from 'vue';
import linkComponents, {directiveInstall} from 'link-components';
import 'link-components/lib/style.css'
import './vxe-table.css'
import IconSelect from '@/components/IconSelect/index.vue';
import BindDict from '@/components/BindDict/index.vue';
import BindEntity from '@/components/BindEntity/index.vue';
import { encodeAes } from '@/utils/cipher';
import {ElNotification} from "element-plus";
import {deleteData, getFileList} from '@/api/file/SysFiles';
import type {SetupOptions} from "link-components";
import {getToken, getAccessToken} from '@/utils/auth';

export default (app: App) => {
  app.component(BindDict.name, BindDict);
  app.component(BindEntity.name, BindEntity);
  app.use(linkComponents, {
    components: [
      {
        name: 'IconSelect',
        component: IconSelect
      },
      {
        name: 'BindDict',
        component: BindDict
      },
      {
        name: 'BindEntity',
        component: BindEntity
      }
    ],
    encodeAesFunction: encodeAes,
    uploadAction: `${import.meta.env.VITE_API_URL}file/SysFiles/uploadFile`,
    requestHeaders: () => ({
      'Authorization': getToken()
    }),
    uploadParseData: (response: any, _file: any) => {
      if (response.code === 200) {
        return {
          ...response.data,
        }
      } else {
        ElNotification({
          title: 'Error',
          message: ''+response.msg,
          type: 'error',
        })
      }
    },
    uploadParseDownLoadUrl: (file: any) => {
      return `${import.meta.env.VITE_API_URL}file/SysFiles/getFile/${file.id}?access-token=${getAccessToken()}`
    },
    uploadDeleteFunction: (file: any) => {
      return new Promise(((resolve, reject) => {
        if (!file.id) {
          resolve('');
          return
        }
        deleteData(file.id).then((res:any) => {
          if (res.code === 200) {
            resolve('')
          } else {
            reject();
          }
        }).catch(_ => reject())
      }))
    },
    uploadLoadFileFunction: (data: any) => {
      return new Promise(((resolve) => {
        if (!data.billId) {
          return resolve([])
        }
        getFileList(data).then((res: Result) => {
          if (res.code === 200) {
            resolve(res.data)
          } else {
            resolve([])
          }
        }).catch(() => resolve([]))
      }))
    }
  } as SetupOptions);
  app.use(directiveInstall)
}
