import request from '@/utils/request';

enum Api {
  listUrl = '/sys/Menu/list',
  saveUrl = '/sys/Menu/save',
  deleteUrl = '/sys/Menu/delete/',
  viewUrl = '/sys/Menu/view/',
  changeEnableUrl = '/sys/Menu/changeEnable',
  getMenuTreeDataUrl = '/sys/Menu/getMenuTreeData',
  getAllMenuTreeDataUrl = '/sys/Menu/getAllMenuTreeData',
}
export function getMenuTreeData() {
  return request({
    url: Api.getMenuTreeDataUrl,
    method: 'GET',
  });
}
export function getAllMenuTreeData() {
  return request({
    url: Api.getAllMenuTreeDataUrl,
    method: 'GET',
  });
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

