# LDP框架ChangeLog&升级方式

## 常规升级方式说明

1. 备份数据库以及uaa资料库（自定义变更）

2. 删除uaa资料库文件（uaa有变更时）

   ```shell
   rm -rf uaaresources/
   rm -rf uaarestmp/
   ```

3. 替换变更后的fatjar中的jar包，或者使用最新LDP应用程序包

4. 启动新版的LDP

5. uaa资料库拷贝对应认证域的模板



## 2020-12-28

版本号： **1.1.18**

**base-server**

`Feat`：

1. HqlWhereHelper增加join级联查询、order排序等
2. 扩展jdbc: 支持单sql多参数批量执行（根据参数对同一条sql执行多次）
3. common-rest支持swagger
4. 角色添加数据权限授权模式字段

`Fix`：

1. 修复hql count语句替换逻辑（忽略大小写）
2. 修复RestTemplate，token拦截器空指针异常问题
3. 修复不能获取Oracle表结构元数据问题
4. 修复Oracle 参数in条件查询不能超过1000的问题(多条件拼接需要额外添加括号)
5. Excel导入导出适配Oracle

`Others`：

1. 解决各模块依赖包版本冲突
2. 删除用户实体的关联
3. 调整相关模块（业务去掉dubbo远程调用，默认支持rest）



**mcs-service**

`Feat`：

1. 账号、员工、组织、岗位新增模糊查询
2. 用户数据权限支持多模式授权
3. 树形转换工具支持转换多棵树
4. 优化功能权限逻辑（支持挂载未授权的权限项）

`Fix`：

1. 修复员工同步账号报错
2. 修复组织树卡死问题（优化树形接口执行速度）

`Others`：

1. 剥离mcs-common中的dubbo远程依赖

2. maven配置中区分项目包版本、基础服务依赖包版本

3. 解决各模块依赖包版本冲突



**mcs-ui**

`Feat`：

1. 员工管理增加组织树过滤
2. 编码规则限制总长度为40
3. 新增扩展外部图标解决方案
4. 数据权限角色新增模式[自定义、本级、本级及子级]

`Fix`：

1. 替换树形组件（解决卡死问题）
2. 修复字段删除时自动删除关联关系

`Others`：

1. 优化部分加载动画

2. 优化模型设计常用字段新增方式




**gen-service**

`Feat`：

1. 一对一、多对一默认添加@NotFound注解

`Fix`：

1. 修复对象自引用一对一生成为一堆多的问题




**ldp-app-example（后端脚手架）**

`Feat`：

1. 集成文档生成knife4j、swagger
2. Feign请求添加超时时间配置
3. 去掉默认的dubbo依赖

`Fix`：

1. 修复依赖包各种版本冲突问题



**ldp-appui-example（前端脚手架）**

`Feat`：

1. 应用端用管理员账号登录可以通过菜单跳转到管理端
2. 新增扩展外部图标解决方案
3. 新增导航权限判断是否隐藏菜单
4. 新增与后端本地联调配置

`Fix`：

1. 修复用户功能权限调用接口



### 本次更新方式

1. 替换ldp-manage/fatjar 目录下对应的jar包
2. 替换nginx中mcs的前端代码
3. 脚手架更新到`1.1.16`



- HqlWhereHelper工具使用文档参照：[Hibernate条件查询工具类使用](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/开发文档/Hibernate条件查询工具类使用.md)

- 页面权限项配置说明文档：[LDP页面权限项配置文档](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/操作文档/LDP应用页面权限项配置说明.md)

- mcs、前端脚手架扩展外部图标说明文档： 待补充

- 前端脚手架联调配置说明文档：待补充

- Knife4j、Swagger使用文档：待补充

- 数据权限授权模式说明文档：待补充

  



## 2020-11-11

版本号： **1.1.15**

**base-server**

`Feat`：

1. 扩展通用接口，加入getCurrentSession方法
2. hql参数构建扩展，可以传入自己的条件列表获取实例
3. 扩展文件存储接口，支持mcs服务



**mcs-service**

`Feat`：

1. 菜单授权角色关联用户新增过滤条件
2. 同步员工数据到用户(如果已存在，则覆盖)

`Fix`：

1. 修复配置项值错误问题
2. 修复领域列表批量删除问题

`Others`：

1. 根节点查询默认从字典中获取值

2. 添加管理菜单时，默认给超级管理员授权

3. 应用角色可以关联管理账号

   

**gen-service**

`Feat`：

1. 数据模型可以修改表名
2. 数据模型可以引用标准功能

`Fix`：

1. 修复旧业务模型保存失败问题

2. 修复表名修改后发布时，字段不能修改问题

   

**mcs-ui**

`Feat`：

1. 模型设计数据库表名、引用功能
2. 视图设计添加附件、附件表格组件
3. 员工同步到用户功能

`Fix`：

1. 修复预览界面不显示附件组件
2. 修复配置项值维护数据提交问题
3. 修复新增字典弹窗中编码不能输入的问题
4. 修复组织默认选择上级无效问题
5. 修复数据模型复制功能
6. 修复视图设计切换页面布局方式，丢失表单控件问题

`Others`：

1. 优化部分样式（调整控件大小、按钮大小、滚动条等）

2. 开放用户类型修改

3. 将修改头像入口放到设置中

   

### 本次更新方式

1. 替换ldp-manage/fatjar 目录下对应的jar包

2. 脚手架更新到`1.1.15`（标准附件功能）

3. nacos上需要为已使用的配置文件添加以下配置(员工同步用户的默认密码)

   ```yml
   mcs:
     sync:
       employee:
         user-password: 1234561
   ```
   
   



- 部分功能使用文档后续更新



## 2020-10-23

版本号： **1.1.13**

**base-server**

`Feat`：

1. hibernate批量删除接口
2. 文件服务添加下载地址以及自动注入用户信息

`Others`：

1. 更新服务group名，新增dev、test、prod配置文件

2. 补全初始化权限元素

   

**mcs-service**

`Feat`：

1. 附件上传下载功能

`Fix`：

1. 修复头像上传后缓存不刷新的问题

`Others`：

1. 更新服务group名，新增dev、test、prod配置文件
2. 修改系统配置项默认值



**gen-service**

`Feat`：

1. 业务模型和数据模型新增新增code字段，用作生成代码的包名及接口地址
2. code修改时视图设计接口实时变更

`Fix`：

1. 修复在windows上字符编码错误问题
2. 修复所有由于code功能变更的错误
3. 修复批量删除接口实现



**mcs-ui**

`Feat`：

1. 重构整个模型设计界面
2. 表单/单据添加附件控件

`fix`：

1. 修复视图设计自动生成模板可能保存失败的问题
2. 修复视图设计中数据没有变化切换视图不出现提示的问题
3. 修复开发者名称修改失效问题
4. 修改数据模型复制错误问题

`Others`：

1. 应用/管理菜单权限配置界面添加滚动条
2. 菜单维护删除二次确认
3. 应用认证管理搜索条件修改为下拉选择
4. 其它部分优化



**uaa-service**

`Others`：

1. 更新服务group名，新增dev、test、prod配置文件
2. 远程配置文件补全token自动续期配置



**gateway-service**

`Others`：

1. 更新服务group名，新增dev、test、prod配置文件
2. 远程配置文件补全下载接口忽略配置



**job-service**

`Others`：

1. 更新服务group名，新增dev、test、prod配置文件



### 本次更新方式

1. 替换ldp-manage/fatjar 目录下对应的jar包
2. 替换ldp-manage/conf/boot.conf文件，并参照conf目录下的README.md修改对应的配置
3. 修改应用端LDP相关依赖jar包版本为`1.1.13`
4. nacos上需要为几个服务添加dev和prod为后缀的配置文件



- 更新**LDP集中式安装部署说明文档**：[LDP集中式安装部署说明](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/LDP集中式安装部署说明.md)



## 2020-10-13

版本号：**1.1.12**

### 更新内容

**base-service**

`Feat`：

1. 集成第三方对象存储服务（阿里云、腾讯云、七牛云、minio)
2. 字典值批量注入注解及工具类



**启动脚本**

`Feat`：

1. 启动脚本区分开发环境和生产环境
2. 检查host以及基础服务port是否可以连通

`Others`：

1. 修复job脚本启动问题
2. 修复基础服务启动检测



### 本次更新方式

1. 替换ldp-manage/fatjar 目录下对应的jar包
2. 修改应用端LDP相关依赖jar包版本为`1.1.12`



- 第三方对象存储服务使用参照：[LDP第三方对象存储服务使用说明](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/开发文档/LDP第三方对象存储服务使用说明.md)
- 字典值批量注入注解及工具类参照：[LDP框架自定义注解](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/开发文档/LDP%20框架自定义注解.md) 第八章节、字典对象属性填充注解
- 启动配置文档及脚本变更参照：安装包解压后查看 ldp-manage/conf/README.md



## 2020-09-24

版本号：**1.1.10**

### 更新内容

**base-service**

`Feat`：

1. 完善ORM查询工具类HqlWhereHelper （如：>、<、>=、<=等等）
2. GenericDao接口新增执行hql的方法

`Fix`：

1. 修复findAll参数克隆导致空指针异常
2. 修复阿里云短信发送失败无提示的问题

`Others`：

1. 上传文件接口可指定fileId
2. ldp内部相关包依赖方式修改为provided （避免包冲突问题）
3. dubbo远程调用异常信息统一处理



**mcs-service**

`Feat`：

1. 忘记密码验证方式动态配置接口
2. 多字段格式化自定义填充算法实现
3. 新增修改管理平台LOGO的接口
4. 新增修改用户头像的接口

`Others`：

1. mcs-common对其它LDP依赖包修改为provided（避免包冲突问题）



**mcs-ui**

`Feat`：

1. 管理平台LOGO修改功能
2. 用户头像修改功能
3. MCS主题切换功能
4. 忘记密码验证方式动态配置

`Others`：

1. 优化部分模块显示问题

   

### 本次更新方式

1. 替换ldp-manage/fatjar 目录下对应的jar包
2. 修改应用端LDP相关依赖jar包版本为`1.1.10`



- HqlWhereHelper 使用文档：[Hibernate条件查询工具类使用](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/开发文档/Hibernate条件查询工具类使用.md)
- 自定义填充算法实现参照：[LDP 框架自定义注解使用说明文档](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/开发文档/LDP框架自定义注解.md)
- LOGO修改/头像修改/主题切换操作文档：[操作文档](http://gitlab.dev.shxrtech.com/doc/ldp-docs/blob/master/%E6%93%8D%E4%BD%9C%E6%96%87%E6%A1%A3/LDP-MCS%E5%89%8D%E7%AB%AF%E8%AE%BE%E7%BD%AE&%E4%BA%BA%E7%89%A9%E5%A4%B4%E5%83%8F%E4%B8%8A%E4%BC%A0&%E9%85%8D%E7%BD%AE%E6%89%BE%E5%9B%9E%E5%AF%86%E7%A0%81%E9%AA%8C%E8%AF%81%E6%96%B9%E5%BC%8F.md)



## 2020-09-17

版本号：**1.1.9**

### 更新内容

1. 修复`1.1.6`版本部分jar包仍然依赖SNAPSHOT的问题。

### 本次更新方式

1. 替换ldp-manage/fatjar 目录下对应的jar包
2. 修改应用端LDP相关jar包版本为`1.1.9`

=====================================================================================

版本号：**1.1.6**

### 更新内容

为了解决开发环境jar包不断变更引起的各种版本不一致问题，修改所有工程发版方式，以后每次发版将相关jar包`deploy`成`release`的包，例如，本次发版的base-api依赖方式为：

```xml
<dependency>
    <groupId>com.sinra.ldp</groupId>
    <artifactId>base-api</artifactId>
    <version>1.1.6</version>
</dependency>
```

项目开发时尽量引用正式版本的jar包，这样开发环境的任何修改都不会导致版本不一致。如果需要新功能，只需要修改到对应的版本号即可。



## 2020-09-10

版本号：**1.0.67-hotfix**

### 更新内容

**base-service**

`Others`：

1. 修改merge方法增加返回值



**gen-service**

`Fix`：

1. 修复变量名根据类名生成后，前端表单提交与后端代码不同步的问题



**mcs-service**

`Fix`：

1. 修复配置项描述不能修改的bug

   

**mcs-ui**

`Fix`：

1. 修复【配置项管理->分环境设置配置参数】界面，只有一条数据时，界面不刷新的问题。
2. 修复相同分组下配置项key可能相同的bug

`Others`：

1. 优化配置项排序问题


### 本次更新操作
1. 替换ldp-manage/fatjar 目录下对应的jar包

2. 替换nginx目录下的mcs静态文件



## 2020-09-08

版本号：**1.0.67**

### 更新内容

**base-service**

`Feat`：

1. 服务间通信拦截器（携带用户信息）
2. 手机发送验证码（忘记密码）
3. 关闭所有强制检测远程依赖

`Fix`：

1. JdbcDao执行事务操作异常处理
2. 修复本地DAO参数map多次使用变量引用被修改的问题
3. 修复应用端方言使用oracle导致日志写入报错的问题

`Others`：

1. 返回结果类新增快速返回结果的方法（RestResult.ok()、RestResult.error()）
2. ResultMsg枚举类新增参数验证失败(ResultMsg.PARAM_ERROR)



**mcs-service**

`Feat`：

1. 应用发布配置功能
2. 发布本地Dao代码
3. 同时发布前后端代码
4. 发布日志
5. 短信服务器配置/密码找回
6. 配置项管理



**uaa-service**

`Fix`：

1. 修复账号密码自动填充时错位问题



**gateway-service**

`Others`：

1. token验证忽略代码生成模块下载接口 （修改配置文件）



**gen-service**

`Feat`：

1. 工程服务化改造
2. 前端代码分服务存储
3. 发布流程改造

`Fix`：

1. 修复视图设计树形过滤数组越界问题
2. 修复git脚本执行异步问题

`Others`：

1. 变量名根据类名生成，不使用id生成



**mcs-ui**

`Feat`：

1. 应用发布配置管理
2. 视图设计添加发布(支持前端和服务端同步发布)
3. 发布日志
4. 配置项管理
5. 短信服务器(找回密码添加手机短信验证码方式找回)
6. 视图设计增加控件拖拽排序， 列配置排序。

`Fix`：

1. 预览页面多标签切换有几率冲突问题。
2. 找回密码验证成功后点击确定无法返回授权登录页面问题。



### 本次配置变更说明

1. 修改nacos上gateway配置文件中`ldp.ignore-urls`添加以下两个地址 (忽略下载接口的token验证）

   ```yml
   - /**/download
   - /**/codedownload
   ```

2. 修改nacos上base配置文件（新增nacos日志等级配置）

   ```yaml
   logging:
     level:
       com.sinra: DEBUG
       com.alibaba.nacos: WARN
   ```

发布功能最新使用方式参照文档[MCS快速开发-发布功能使用文档](操作文档/MCS快速开发-发布功能使用文档.md)







