# LDP前端框架自定义组件使用说明

## 通用配置

### `axios`接口交互说明

> `LDP前端框架项目`基于`axios`接口访问交互
>
> 功能封装于`utils/request.js`中

- `axios`部分功能使用说明

  1. 调用接口时显示**loading状态**

     ```javascript
     import request from '@/utils/request'
     request({
         url: url,
         method: 'get',
         // 设置显示loading状态
         showLoading: true
     })
     ```
  
  
2. 调用接口时**关闭默认错误提示**
  
     ```javascript
     import request from '@/utils/request'
     request({
         url: url,
         method: 'get',
         // 设置关闭报错提示
         noMessage: true
   })
   ```
### 会话已过期说明

> 当用户登录token过期后，访问接口会报错401，此时从axios拦截器中获取到错误码，会默认进行跳转到401页面。目前会话失效有两种模式。(跳转模式，弹框模式)

- 会话失效两种模式的配置方法

  > 配置文件在 `src/setting.js`中
  >
  > `checkTokenType` 0 表示跳转401页面， 1表示弹框提示



1.  当前token过期后默认会跳转401页面

   ```javascript
   // src/setting.js
   module.exports = {
     // 检测token过去类型 0为跳转401页面  1为弹框提示
     checkTokenType: 0,
     ...
   }
   ```

![会员已过期](../imgs/401.png)

2. 弹框提示

   ```javascript
   // src/setting.js
   module.exports = {
     // 检测token过去类型 0为跳转401页面  1为弹框提示
     checkTokenType: 1,
     ...
   }
   
   ```

   ![会话已过期](../imgs/token-expired-dialog.png)



## 通用组件

### 常规组件

> 路径在src/components 大部分常规组件
>
> 比如说 table form tree等

- `EditDataTable` 最长用表格 (一般列表页面都是用此表格)

  参数说明

  | 参数名                | 类型             | 说明                            |
  | --------------------- | ---------------- | ------------------------------- |
  | `head`                | `Array`          | 表格列头数组  必填              |
  | `rowKeyField`         | `String`         | 行唯一标志 默认是id             |
  | `showSelection`       | `Boolean`        | 显示多选类型表格                |
  | `showNumber`          | `Boolean`        | 显示表格序号                    |
  | `height`              | `String||Number` | 表格高度 默认自动计算全屏       |
  | `showOverflowTooltip` | `Boolean`        | 内容超出显示tip                 |
  | `noPagination`        | `Boolean`        | 无分页。 默认表格下面自带分页器 |
  | `editable`            | `Boolean`        | 是否可编辑， 默认不可编辑       |
  | `showAdd`             | `Boolean`        | 显示新增行                      |

- `DynamicForm` 动态表单组件

  `DynamicFormItem`  动态子表单组件里面封装调用了部分element-ui组件

  比如说`el-input` `el-select` 等 

  > 当前前端项目中大部分表单处理都是使用此组件

  `DynamicForm` 参数说明

  | 参数名       | 类型      | 说明                               |
  | ------------ | --------- | ---------------------------------- |
  | `formConfig` | `Object`  | 表单配置对象                       |
  | `disabled`   | `Boolean` | 是否禁用                           |
  | `value`      | `Object`  | 表单绑定对象                       |
  | `labelWidth` | `String`  | 表单控件标题宽度                   |
  | `showBtn`    | `Boolean` | 是否显示表单内置按钮（确定，取消） |
  | `space`      | `Number`  | 表单间距                           |

  事件说明

  > 下列参数说明
  >
  > **key**: 控件绑定的属性名
  >
  > **value**: 控件绑定的值
  >
  > **data**: 表单的总数据对象

  | 事件名              | 参数列表      | 说明                                       |
| ------------------- | ------------- | ------------------------------------------ |
  | `controlDataChange` | `{key,value}` | 当表单中控件内容变化时触发                 |
  | `getContent`        | `{key,value}` | 当表单中控件是选择弹框时候值改改变时候触发 |
  | `modelItem`         | `{key,value}` | 当表格中树形控件改变时候触发               |
  | `submit`            | `data`        | 当点击提交按钮时候触发                     |
  | `cancelForm`        |               | 点击取消时候触发                           |
  
  `formConfig` 表单控件配置说明
  
  
| 属性名        | 类型            | 说明                                       |
| ------------- | --------------- | ------------------------------------------ |
| `label`       | `String`        | 控件标题                                   |
| `key`         | `String`        | 表单绑定的字段名                           |
| `type`        | `String`        | 表单类型 `input|select|databox|textarea`等 |
| `span`        | `Number`        | 一行按照24列分 每一列占用的比例            |
| `placeholder` | `String`        | 控件提示信息                               |
| `rules`       | `Array||Object` | 详情请查看`element-ui`常规验证用           |

  使用例子

  ```vue
  <template>
    <div class="app-container page-overflow-y">
      <el-card class="box-card">
        <dynamic-form
          labelWidth="110px"
          :formConfig="formConfig"
          v-model="form"
          @submit="onSubmit"
          @cancelForm="onCancelForm"
          ref="pageForm"
        />
      </el-card>
    </div>
  </template>
  <script>
  export default {
      data() {
          return {
             form: {
              appName: '',
              appNameEn: ''
            },
            formConfig: {
                formItemList: [{
                  label: '应用ID',
                  key: 'appId',
                  type: 'input',
                  span: 8,
                  placeholder: '请输入应用ID',
                  rules: [{ required: true, message: '应用ID必填', trigger: 'change' }]
                },   {
              label: '认证应用名称',
              key: 'appName',
              type: 'input',
              span: 8,
              placeholder: '请输入认证应用名称',
              rules: [{ required: true, message: '认证应用名称必填', trigger: 'change' }]
            }]
            }
          }
      },
      methods: {
          // 点击提交时候事件
          onSubmit() {
              ...dosomething
          }，
        // 点击取消事件
          onCancelForm() {
              this.$router.back()
          }
      }
  }    
  </script>
  ```

  

### 设计器生成视图运行时组件

> 路径在`src/gencomponents`

- `ConnentDataBox` 选择弹框组件(基于`dataSelectDlg` 组件)

  ```vue
  <!--  template 组件模板 v-model绑定的值为对象类型 -->
  <connent-data-box
      v-model="databox"
      v-bind="attrs"
      v-on="$listeners"
      @confirm="confirm"
      >
  </connent-data-box>
  
  <script> 
  export default { 
  	data() {
          return {
              databox: {},
              databoxOptions: {
                   'key': 'pid',
                   'props': { // 
                       'label': 'projectName',
                       'value': 'id'
                   },
                   'url': '/example-service/resource/projectresource/get/page',
                   'hostUrl': '/example-service/resource/projectresource/get/page',
                   'method': 'get',
                   'extendParms': {
                      'queryFieldItem': 'id,number,name'
                   },
                   'disabled': false,
                   'multiple': false,
                   // 显示表格中的列配置
                   'tableColumn': [
                       {
                          'property': 'id',
                          'label': '编码',
                           // 是否作为搜索条件
                          'query': {
                              'type': 'input'
                          }
                       },
                       {
                           'property': 'projectName',
                           'label': '名称',
                           'query': {
                              'type': 'input'
                           }
                      }
                   ]
               }
          }
      },
      methods: {
          // 点击确定会触发confirm事件
          confirm(val) {
              
          }
      }
  }
  </script>
  
  
  ```

- `ComTable` 功能列表中的表格组件

  props 参数说明

  | 参数名          | 类型      | 说明             |
  | --------------- | --------- | ---------------- |
  | `requestUrl`    | `String`  | 请求url地址      |
  | `tableHead`     | `Array`   | 表格列配置数组   |
  | `showSelection` | `Boolean` | 是否显示多选框   |
  | `showNumbe`     | `Boolean` | 是否显示序号     |
  | `isAceBind`     | `Boolean` | 是否启用权限绑定 |

  使用例子

  ```vue
  <template>
      <com-table
                 ref="table"
                 :request-url="requestUrl"
                 :table-head="tableHead"
                 >
      </com-table>
  </template>
  <script> 
  export default {
      data() {
          requestUrl: '/example-service/resdemo/customerdemo/get/page'
          tableHead: [ {
              'label': '主键ID',
              'key': 'id',
              'ctrlType': null
            },
            {
              'label': '客户代码',
              'key': 'customerCode',
              'ctrlType': 'input'
            },
            {
              'label': '客户名称',
              'key': 'customerName',
              'ctrlType': 'input'
            }
          ]
      }
  }
  </script>
  
  ```

- `ComEditTable` 可编辑表格   

  基于`elx-editable`组件 详情参数事件说明请查看`elx-editable`

  `ComEditTable ` props参数说明

  | 参数名         | 类型       | 说明                                     |
  | -------------- | ---------- | ---------------------------------------- |
  | `data`         | `Array`    | 表格数据                                 |
  | `tableHead`    | `Array`    | 表格表头列数组                           |
  | `editConfig`   | `Object`   | 编辑模式                                 |
  | `showAdd`      | `Boolean`  | 是否显示新增行 默认显示                  |
  | `beforeAddRow` | `Function` | 新增行回调函数，返回true则不执行默认新增 |
  | `showIndex`    | `Boolean`  | 是否显示序号 默认不显示                  |
  | `editRules`    | `Object`   | 激活后显示的控件                         |

  ```vue
  <com-edit-table
      ref="devtests"
      :data.sync="table.devtests.tableData"
      :edit-rules="table.devtests.editRules"
      :table-head="table.devtests.tableHead"
      >
  </com-edit-table>
  <script> 
  export default {
      data() {
        'table': {
          'devtests': {
            'key': 'devtest',
            'tableData': [],
            'tableHead': [
              {
                'label': '测试人员',
                'key': 'testName',
                'ctrlType': 'input',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElInput'
                }
              },
              {
                'label': '测试类型',
                'key': 'testType',
                'ctrlType': 'input',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElInput'
                }
              },
              {
                'label': '开始',
                'key': 'startDate',
                'ctrlType': 'date',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElDatePicker',
                  'props': {
                    'type': 'date',
                    'format': 'yyyy-MM-dd',
                    'value-format': 'yyyy-MM-dd HH:mm:ss'
                  }
                }
              },
              {
                'label': '结束',
                'key': 'endDate',
                'ctrlType': 'date',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElDatePicker',
                  'props': {
                    'type': 'date',
                    'format': 'yyyy-MM-dd',
                    'value-format': 'yyyy-MM-dd HH:mm:ss'
                  }
                }
              }
            ]
          }
        }
      }
  }
  </script>
  
  ```

  

- `ComCollapse` 折叠面板

  > 折叠子组件 只需要在`ComCollapse ` 里面填写子组件即可

  ```vue
  <com-collapse title="基本信息">
      <el-table></el-table>
      ...
  </com-collapse>
  ```

  

### `mixins`混入

> 混入到`vue`组件实例中进入某些默认操作

- `DataTableMixin` 主要配合`EditDataTable`表格组件

  使用例子如下：

  ```vue
  <template>
  	<edit-data-table>
      	...
      </edit-data-table>
  </template>
  <script>
  import '@/components/EditDataTable'
  import DataTableMixin from '@/mixins/DataTableMixin'
  export default {
    mixins: [DataTableMixin, AceCommon],
    data() {
        return {
            ...
        }
    }
  }
  </script>
  ```

  默认数据`data`

  | 属性名    | 类型     | 说明                           |
  | --------- | -------- | ------------------------------ |
  | **list**  | `Array`  | 列表显示的数据                 |
  | `_url`    | `String` | 访问地址                       |
  | `_params` | `Object` | 请求接口参数                   |
  | `_query`  | `Object` | 搜索条件配合搜索组件使用       |
  | `page`    | `Number` | 当前页码(表格组件中分页器使用) |
  | `total`   | `Number` | 总条数(表格组件中分页器使用)   |

  默认方法`methods`

  | 方法名                | 参数           | 说明                   |
  | --------------------- | -------------- | ---------------------- |
  | **dataTableInit**     |                | 请求数据使用           |
  | `dataTableSearch`     | val(搜索条件)  | 搜索组件使用触发的方法 |
  | `dataTablePageChange` | page(当前页码) | 点击分页器触发         |

  

- `AceCommon` 用来判断当前路由页面是否具有视图权限

  > 控制是否具有权限访问当前页面，如果没权限则会跳转显示无权限页面`noAccess`。

  使用例子如下:

  ```vue
  <script>
  import AceCommon from '@/mixins/AceCommon'
  export default {
      // 直接引入即可
    mixins: [AceCommon]
  }
  </script>
  
  ```

  说明

### 自定义指令

> 自定义指令

- `el-drag-dialog` 

  使用例子 在`el-dialog上添加 v-el-drag-dialog` 即可使用

  ```vue
  <el-dialog
    :enableDrag="true"
    title="代码展示"
    :visible.sync="dialogVisible"
    width="75%"
    top="40px"
    style="min-height: 550px;"
    v-el-drag-dialog
    :modal="true"
    :modal-append-to-body="false">
  </el-dialog>
  ```

  

- `ace` 给按钮或者其他控件设置操作权限

  >已在`main.js`中全局注册 直接使用就行。

  | 指令编码   | 说明 |
  | ---------- | ---- |
  | `DEL_BTN`  | 删除 |
  | `ADD_BTN`  | 新增 |
  | `EDIT_BTN` | 编辑 |

  使用例子

  ```vue
  // ... 使用v-ace:DEL_BTN 绑定删除权限
  <template>
        <el-button icon="el-icon-delete" v-ace:DEL_BTN type="danger" @click="deleteBatchUserSelect">删除</el-button>
  </template>
  // ... 也可以绑定动态变量
  <template>
        <el-button icon="el-icon-delete" v-ace="ace" type="danger" @click="deleteBatchUserSelect">删除</el-button>
  </template>
  
  <script>
      export default {
          data() {
              return {
                  // 也可以是,分割的多权限 比如 ADD_BTN,DEL_BTN
                  ace: 'DEL_BTN'
              }
          }
      }
  </script>
  ```