# LDP统一认证登录配置

在mcs中对应用配置统一认证时，根据配置的不同，能达到不同的登录控制效果。

### 一、样例数据

**应用**

- 应用系统A：认证领域编码 demo

**用户**

- 用户1： 类型-管理，系统标识-无
- 用户2： 类型-应用，系统标识-无
- 用户3： 类型-应用，系统标识-demo
- 用户4： 类型-应用，系统标识-example

### 二、认证服务接口地址配置

在mcs中，打开左侧菜单`应用认证管理`->`认证服务`，找到认证领域demo的认证服务，点击修改，登录配置只需要修改下图圈中的接口地址即可：

![](../imgs/UAA登录配置.png)

#### 2.1 不做限制，所有用户均可登录

将接口地址设置为user/alllogin

```java
// 所有用户均可登录
user/alllogin
```

#### 2.2 管理用户、应用用户（无系统标识或相同系统标识）均可登录

将接口地址设置为user/applogin，配置相关参数用户类型usertype=0，系统标识sysid=demo

```java
// 除了用户4由于系统标识不一致不能登录，用户1、用户2、用户3均可登录
user/applogin?usertype=0&sysid=demo
```

#### 2.3 仅应用用户（不检查系统标识）可登录

将接口地址设置为user/login，并设置应用类型usertype=0

```java
// 除用户1是管理用户不能登录，用户2、用户3、用户4均可登录
user/login?usertype=0
```

#### 2.4 仅应用用户（相同系统标识）可登录

将接口地址设置为user/login，并设置应用类型usertype=0，系统标识sysid=demo

```java
// 仅用户3满足条件，可以登录，其它用户均不可登录
user/login?usertype=0&sysid=demo
```