# LDP框架升级参考文档

此文档为框架升级一份参考文档，根据情况判断升级时需要做哪些操作。

## 一、升级前准备工作

升级前，请先打开chanlog文档：[LDP框架ChangeLog&升级方式.md](../LDP框架ChangeLog&升级方式.md)

### 1.1、关闭服务

```shell
# 关闭主要的服务
./ldp-boot.sh stop

# 关闭bpm服务
./bpm-boot.sh stop

# 关闭报表服务
./report-boot.sh stop
```

### 1.2、 备份DB

虽然一般升级不会对已有的数据造成影响，但是建议先备份一份数据。

### 1.2、 UAA资源库备份（登录界面有自定义变更）

查看changelog文档，检查UAA是否有变更，如果有，则需要先备份UAA资源库，然后删除掉UAA资源库

```shell
# 创建uaa字员文件备份文件夹
mkdir -p bak/uaaui
# 备份uaaui自定义变更
cp -r ~/.ldp/uaaui/* bak/uaaui
# 删除资源库中的文件
rm -rf ~/.ldp/uaaui
```

 等新版UAA重新启动后，再根据变更进行修改或者直接拷贝回去。

### 1.3、备份jar包

将老版本jar包进行备份，新版升级失败可以紧急回滚，如果新版正常运行一段时间后，可以删除掉备份文件

```shell
# 创建fatjar备份文件夹
mkdir -p bak/fatjar
# 备份fatjar
mv ldp-manage/fatjar/* bak/fatjar/
```

## 二、升级

### 2.1、解压新版tar包

解压新版tar的方式可以有很多，这里建议新建一个当前日期的目录文件夹，方便和旧版本的做区分，也方便拷贝文件

```shell
# 创建新版目录与之前的ldp-manage目录平级
mkdir ldp-20210716
# 将新版tar包移到刚才新建的目录下，这里的版本号不一定一致
mv ldp-manage-1.2.46.tar.gz ldp-20210716

# 切到新版目录下，并执行解压
cd ldp-20210716
tar -zxvf ldp-manage-1.2.46.tar.gz
```

### 2.2、将新版jar包拷贝到fatjar目录

```shell
# 当前目录在ldp-20210716下,
cp ldp-manage/fatjar/* ../ldp-mange/fatjar
```

### 2.3、拷贝新版ui文件到nginx/html目录下

```shell
# 拷贝mcs前端
cp -r ldp-manage/ui/mcs /usr/share/nginx/html
```

### 2.3、新增、修改配置文件

查看changelog文档，在`本次更新方式`中，是否有配置文件的变更，如果有则打开NACOS按照描述添加及修改配置文件。

### 2.4、拷贝启动脚本到tool目录（启动脚本有变更、新服务启动脚本）

```shell
cp ldp-manage/tool/* ../ldp-manage/tool/
```

### 2.5、启动新版服务

```shell
# 切到tool目录下
cd ../ldp-manage/tool
# 启动服务
./ldp-boot.sh start
```

### 2.6、测试

服务启动成功后，打开mcs地址验证是否OK。



**PS：BPM升级方式和上面类似，这里就不展开叙述**



