# LDP前端框架自定义组件使用说明

## 通用配置

### `axios`接口交互说明

> `LDP前端框架项目`基于`axios`接口访问交互
>
> 功能封装于`utils/request.js`中

- 接口请求数据说明

  ```javascript
  // 访问接口需要传递X-Ldp-Token, 和 X-Realm
  service.interceptors.request.use(
    config => {
      if (store.getters.token) {
        // 判断是否默认有设置请求头 如果有则不读取缓存信息
        if (!config.headers['X-Ldp-Token']) {
          config.headers['X-Ldp-Token'] = getToken()
        }
        if (!config.headers['X-Realm']) {
          config.headers['X-Realm'] = process.env.VUE_APP_REALMCODE
        }
      }
      if (config.showLoading) {
        showLoading(config.loading)
      }
      return config
    },
    error => {
      return Promise.reject(error)
    }
  )
  ```

- 接口返回数据`response`拦截器说明

  > 默认情况下如果数据错误，会报错提示。
  >
  > 如果错误401请查看 `会话失效说明`

  ```javascript
  service.interceptors.response.use(
    response => {
      const res = response.data
      if (response.config.showLoading) {
        closeLoading()
      }
      if (checkToken(response)) {
        return res
      }
      if (response.config && response.config.noMessage) {
        return res
      }
      if (res.code !== 200) {
        Message({
          message: res.message || 'Error',
          type: 'error',
          duration: 5 * 1000
        })
  
        return Promise.reject(new Error(res.message || 'Error'))
      } else {
        return res
      }
    },
    (error, response) => {
      // 判断设置中是否有showLoading 如果有则直接关闭loading状态
      if (error.config.showLoading) {
        closeLoading()
      }
      if (checkToken(error.response)) {
        return Promise.reject(error)
      }
      if (error.config && error.config.noMessage) {
        return Promise.reject(error)
      }
      console.log('err' + error) // for debug
      Message({
        message: error.message,
        type: 'error',
        duration: 5 * 1000
      })
      return Promise.reject(error)
    }
  )
  
  ```

- `axios`其他 功能配置说明

  1. `显示loading状态`

     ```javascript
     import request from '@/utils/request'
     request({
         url: url,
         method: 'get',
         showLoading: true
       })
     ```

     

  2. `关闭默认错误提示`

     ```
     import request from '@/utils/request'
     request({
         url: url,
         method: 'get',
         noMessage: true
       })
     ```

     

### 会话失效说明

> 当用户登录token过期后，访问接口会报错401，此时从axios拦截器中获取到错误码，会默认进行跳转到401页面。目前会话失效有两种模型。(跳转模式，弹框模式)

- 拦截器逻辑代码

```javascript
// ... axios拦截器 路径: utils/request.js
service.interceptors.response.use(
  response => {
    const res = response.data
	// ... 
    // 获取到数据成功后判断token
    if (checkToken(response)) {
      return res
    }
    // ...
  },
  (error, response) => {
    // ...
    // 报错后判断token
    if (checkToken(error.response)) {
      return Promise.reject(error)
    }
    / ...
  }
)

/**
 * @description 检查token是否过期 查看stauts 401
 * @param {Object} response axios拦截器返回信息
 */
function checkToken(response) {
  let isExpired = false
  if (!response) return
  if (typeof response !== 'object') return
  // 判断是否不验证登录失效检测
  if (response.config && response.config.noCheckToken) {
    return false
  }
  // 查看http 状态码是否是401
  if (response.status === 401) {
    isExpired = true
  } else if (response.data && response.data.code && response.data.code === 401) {
    isExpired = true
  }
  if (isExpired) {
    let redirect = ''
    // 判断axios请求参数中是否有设置重定向， 如果设置重定向则重定向当前页面
    if (response.config && response.config.isRedirect) {
      redirect = location.href
    }
    // 判断是跳转401页面
    if (settings.checkTokenType === 0) {
      router.push({
        path: '401',
        query: {
          redirect
        }
      })
    } else if (settings.checkTokenType === 1) { // 判断是否是弹框提示
      if (isTokenExpired) return isExpired
      isTokenExpired = true
      const msg = response.data && response.data.code && response.data.msg ||
        '会话已过期，请点击确定重新登录！'
      MessageBox.alert(msg, '会话已过期', {
        confirmButtonText: '确定',
        callback: action => {
          isTokenExpired = false
          if (action === 'confirm') {
            logout(redirect)
          }
        }
      })
    }
  }
  return isExpired
}

```

- 模式的配置

  >配置文件在 `src/setting.js`中
  >
  >`checkTokenType` 0 表示跳转401页面， 1表示弹框提示



## 通用组件

### 常规组件

> 路径在src/components 大部分常规组件
>
> 比如说 table form tree等

- `EditDataTable` 最长用表格 (一般列表页面都是用此表格)

  参数说明

  | 参数名                | 类型            | 说明                            |
  | --------------------- | --------------- | ------------------------------- |
  | `head`                | `Array`         | 表格列头数组  必填              |
  | `rowKeyField`         | `String`        | 行唯一标志 默认是id             |
  | `showSelection`       | `Boolean`       | 显示多选类型表格                |
  | `showNumber`          | `Boolean`       | 显示表格序号                    |
  | `height`              | `String|Number` | 表格高度 默认自动计算全屏       |
  | `showOverflowTooltip` | `Boolean`       | 内容超出显示tip                 |
  | `noPagination`        | `Boolean`       | 无分页。 默认表格下面自带分页器 |
  | `editable`            | `Boolean`       | 是否可编辑， 默认不可编辑       |
  | `showAdd`             | `Boolean`       | 显示新增行                      |

- `DynamicForm` 动态表单组件

  `DynamicFormItem`  动态子表单组件里面封装调用了部分element-ui组件

  比如说`el-input` `el-select` 等 

  > 当前前端项目中大部分表单处理都是使用此组件

  `DynamicForm` `参数说明

  | 参数名       | 类型      | 说明                               |
  | ------------ | --------- | ---------------------------------- |
  | `formConfig` | `Object`  | 表单配置对象                       |
  | `disabled`   | `Boolean` | 是否禁用                           |
  | `value`      | `Object`  | 表单绑定对象                       |
  | `labelWidth` | `String`  | 表单控件标题宽度                   |
  | `showBtn`    | `Boolean` | 是否显示表单内置按钮（确定，取消） |
  | `space`      | `Number`  | 表单间距                           |

  事件说明

  | 事件名              | 参数列表      | 说明                                       |
  | ------------------- | ------------- | ------------------------------------------ |
  | `controlDataChange` | `{key,value}` | 当表单中控件内容变化时触发                 |
  | `getContent`        | `{key,value}` | 当表单中控件是选择弹框时候值改改变时候触发 |
  | `modelItem`         | `{key,value}` | 当表格中树形控件改变时候触发               |
  | `submit`            | `value`       | 当点击提交按钮时候触发                     |
  | `cancelForm`        |               | 点击取消时候触发                           |

  `formConfig` 表单控件配置说明

  | 属性名        | 类型           | 说明                                       |
  | ------------- | -------------- | ------------------------------------------ |
  | `label`       | `String`       | 控件标题                                   |
  | `key`         | `String`       | 表单绑定的字段名                           |
  | `type`        | `String`       | 表单类型 `input|select|databox|textarea`等 |
  | `span`        | `Number`       | 一行按照24列分 每一列占用的比例            |
  | `placeholder` | `String`       | 控件提示信息                               |
  | `rules`       | `Array|Object` | 详情请查看`element-ui`常规验证用           |

  使用例子

  ```vue
  <template>
    <div class="app-container page-overflow-y">
      <el-card class="box-card">
        <dynamic-form
          labelWidth="110px"
          :formConfig="formConfig"
          v-model="form"
          @submit="onSubmit"
          @cancelForm="onCancelForm"
          ref="pageForm"
        />
      </el-card>
    </div>
  </template>
  <script>
  export default {
      data() {
          return {
             form: {
              appName: '',
              appNameEn: ''
            },
            formConfig: {
                formItemList: [{
                  label: '应用ID',
                  key: 'appId',
                  type: 'input',
                  span: 8,
                  placeholder: '请输入应用ID',
                  rules: [{ required: true, message: '应用ID必填', trigger: 'change' }]
                },   {
              label: '认证应用名称',
              key: 'appName',
              type: 'input',
              span: 8,
              placeholder: '请输入认证应用名称',
              rules: [{ required: true, message: '认证应用名称必填', trigger: 'change' }]
            }]
            }
          }
      },
      methods: {
          // 点击提交时候事件
          onSubmit() {
              ...dosomething
          }，
          // 点击取消事件
          onCancelForm() {
              this.$router.back()
          }
      }
  }    
  </script>
  ```

  

### 设计器生成视图运行时组件

> 路径在`src/gencomponents`

- `ConnentDataBox` 选择弹框组件(基于`dataSelectDlg` 组件)

  ```vue
  <!--  template 组件模板 v-model绑定的值为对象类型 -->
  <connent-data-box
      v-model="databox"
      v-bind="attrs"
      v-on="$listeners"
      @confirm="confirm"
      >
  </connent-data-box>
  
  <script> 
  export default { 
  	data() {
          return {
              databox: {},
              databoxOptions: {
                   'key': 'pid',
                   'props': { // 
                       'label': 'projectName',
                       'value': 'id'
                   },
                   'url': '/example-service/resource/projectresource/get/page',
                   'hostUrl': '/example-service/resource/projectresource/get/page',
                   'method': 'get',
                   'extendParms': {
                      'queryFieldItem': 'id,number,name'
                   },
                   'disabled': false,
                   'multiple': false,
                   // 显示表格中的列配置
                   'tableColumn': [
                       {
                          'property': 'id',
                          'label': '编码',
                           // 是否作为搜索条件
                          'query': {
                              'type': 'input'
                          }
                       },
                       {
                           'property': 'projectName',
                           'label': '名称',
                           'query': {
                              'type': 'input'
                           }
                      }
                   ]
               }
          }
      },
      methods: {
          // 点击确定会触发confirm事件
          confirm(val) {
              
          }
      }
  }
  </script>
  
  
  ```

- `ComTable` 功能列表中的表格组件

  props 参数说明

  | 参数名          | 类型      | 说明             |
  | --------------- | --------- | ---------------- |
  | `requestUrl`    | `String`  | 请求url地址      |
  | `tableHead`     | `Array`   | 表格列配置数组   |
  | `showSelection` | `Boolean` | 是否显示多选框   |
  | `showNumbe`     | `Boolean` | 是否显示序号     |
  | `isAceBind`     | `Boolean` | 是否启用权限绑定 |

  使用例子

  ```vue
  <template>
      <com-table
                 ref="table"
                 :request-url="requestUrl"
                 :table-head="tableHead"
                 >
      </com-table>
  </template>
  <script> 
  export default {
      data() {
          requestUrl: '/example-service/resdemo/customerdemo/get/page'
          tableHead: [ {
              'label': '主键ID',
              'key': 'id',
              'ctrlType': null
            },
            {
              'label': '客户代码',
              'key': 'customerCode',
              'ctrlType': 'input'
            },
            {
              'label': '客户名称',
              'key': 'customerName',
              'ctrlType': 'input'
            }
          ]
      }
  }
  </script>
  
  ```

- `ComEditTable` 可编辑表格   

  基于`elx-editable`组件 详情参数事件说明请查看`elx-editable`

  `ComEditTable ` props参数说明

  | 参数名         | 类型       | 说明                                     |
  | -------------- | ---------- | ---------------------------------------- |
  | `data`         | `Array`    | 表格数据                                 |
  | `tableHead`    | `Array`    | 表格表头列数组                           |
  | `editConfig`   | `Object`   | 编辑模式                                 |
  | `showAdd`      | `Boolean`  | 是否显示新增行 默认显示                  |
  | `beforeAddRow` | `Function` | 新增行回调函数，返回true则不执行默认新增 |
  | `showIndex`    | `Boolean`  | 是否显示序号 默认不显示                  |
  | `editRules`    | `Object`   | 激活后显示的控件                         |

  ```vue
  <com-edit-table
      ref="devtests"
      :data.sync="table.devtests.tableData"
      :edit-rules="table.devtests.editRules"
      :table-head="table.devtests.tableHead"
      >
  </com-edit-table>
  <script> 
  export default {
      data() {
        'table': {
          'devtests': {
            'key': 'devtest',
            'tableData': [],
            'tableHead': [
              {
                'label': '测试人员',
                'key': 'testName',
                'ctrlType': 'input',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElInput'
                }
              },
              {
                'label': '测试类型',
                'key': 'testType',
                'ctrlType': 'input',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElInput'
                }
              },
              {
                'label': '开始',
                'key': 'startDate',
                'ctrlType': 'date',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElDatePicker',
                  'props': {
                    'type': 'date',
                    'format': 'yyyy-MM-dd',
                    'value-format': 'yyyy-MM-dd HH:mm:ss'
                  }
                }
              },
              {
                'label': '结束',
                'key': 'endDate',
                'ctrlType': 'date',
                'defaultValue': null,
                'editRender': {
                  'name': 'ElDatePicker',
                  'props': {
                    'type': 'date',
                    'format': 'yyyy-MM-dd',
                    'value-format': 'yyyy-MM-dd HH:mm:ss'
                  }
                }
              }
            ]
          }
        }
      }
  }
  </script>
  
  ```

  

- `ComCollapse` 折叠面板

  > 折叠子组件 只需要在`ComCollapse ` 里面填写子组件即可

  ```vue
  <com-collapse title="基本信息">
      <el-table></el-table>
      ...
  </com-collapse>
  ```

  

### `mixins`混入

> 混入到`vue`组件实例中进入某些默认操作

- `DataTableMixin` 主要配合`EditDataTable`组件

  ```vue
  <template>
  	<edit-data-table>
      	...
      </edit-data-table>
  </template>
  <script>
  import '@/components/EditDataTable'
  import DataTableMixin from '@/mixins/DataTableMixin'
  export default {
    mixins: [DataTableMixin, AceCommon],
    data() {
        return {
            ...
        }
    }
  }
  </script>
  ```

  

- `AceCommon` 用来判断当前路由页面是否具有视图权限

  > 控制是否具有权限访问当前页面，如果没权限则会跳转显示无权限页面`noAccess`。

  使用例子

  ```vue
  <script>
  import AceCommon from '@/mixins/AceCommon'
  export default {
      // 直接引入即可
    mixins: [AceCommon]
  }
  </script>
  
  ```

  说明

### 自定义指令

> 自定义指令

- `el-drag-dialog` 

  使用例子 在`el-dialog上添加 v-el-drag-dialog` 即可使用

  ```vue
  <el-dialog
    :enableDrag="true"
    title="代码展示"
    :visible.sync="dialogVisible"
    width="75%"
    top="40px"
    style="min-height: 550px;"
    v-el-drag-dialog
    :modal="true"
    :modal-append-to-body="false">
  </el-dialog>
  ```

  

- `ace` 给按钮或者其他控件设置操作权限

  >已在`main.js`中全局注册 直接使用就行。

  | 指令编码   | 说明 |
  | ---------- | ---- |
  | `DEL_BTN`  | 删除 |
  | `ADD_BTN`  | 新增 |
  | `EDIT_BTN` | 编辑 |

  使用例子

  ```vue
  // ... 使用v-ace:DEL_BTN 绑定删除权限
  <template>
        <el-button icon="el-icon-delete" v-ace:DEL_BTN type="danger" @click="deleteBatchUserSelect">删除</el-button>
  </template>
  // ... 也可以绑定动态变量
  <template>
        <el-button icon="el-icon-delete" v-ace="ace" type="danger" @click="deleteBatchUserSelect">删除</el-button>
  </template>
  
  <script>
      export default {
          data() {
              return {
                  // 也可以是,分割的多权限 比如 ADD_BTN,DEL_BTN
                  ace: 'DEL_BTN'
              }
          }
      }
  </script>
  ```