package com.cftech.sys.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * mobile_viewlog 实体类
 * 日志表
 * Created by mb 02/12/2016.
 */ 
@Data
@NoArgsConstructor
public class MobileViewlog implements Serializable {
	/**
	 * 编号
	 */
	private Long id;

	/**
	 * 日志类型1:内部跳转0:外部链接
	 */
	private String type;

	/**
	 * 创建时间
	 */
	private Timestamp createDate;

	/**
	 * 操作IP地址
	 */
	private String remoteAddr;

	/**
	 * 用户代理
	 */
	private String userAgent;

	/**
	 * 请求URI
	 */
	private String requestUri;

	/**
	 * 操作方式
	 */
	private String method;

	/**
	 * 公众号标识
	 */
	private String appid;

	/**
	 * 承载页面的地址
	 */
	private String parenturl;

	/**
	 * 请求参数
	 */
	private String params;
	/**
	 * 服务号标识
	 * */
	private Long accountsid;

}