package com.cftech.mp.qrcode.service.impl;

import com.cftech.mp.qrcode.model.QrCode;
import com.cftech.mp.qrcode.dao.QrCodeMapper;
import com.cftech.mp.qrcode.service.QrCodeService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
* 微信带参二维码ServiceImpl
*
* @author strive
* @date: 2017-04-25 11:25
*/
@Service("qrCodeService")
public class QrCodeServiceImpl extends GenericServiceImpl<QrCode> implements QrCodeService {

    @Autowired
    @Qualifier("qrCodeMapper")
    private QrCodeMapper qrCodeMapper;

    @Override
    public GenericDao<QrCode> getGenericMapper() {
        return qrCodeMapper;
    }

    @Override
    public QrCode bySceneFindQrcode(String scene) {
        return qrCodeMapper.bySceneFindQrcode(scene);
    }
}