package com.cftech.mp.wechat.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.mp.wechat.dao.MenuMapper;
import com.cftech.mp.wechat.model.Menu;
import com.cftech.mp.wechat.service.MenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * menuService
 * Created by lisw 31/10/2016.
 */
@Service("menuService")
public class MenuServiceImpl extends GenericServiceImpl<Menu> implements MenuService {

	/**
	 * menuMapper
	 */
	@Autowired
	@Qualifier("menuMapper")
	private MenuMapper menuMapper;

	@Override
	public GenericDao<Menu> getGenericMapper() {
		return menuMapper;
	}

	@Override
	public List<Menu> fetchSearchByPageSeach(Conds conds, Sort sort, int page,
			int pageSize,Long id) {
		 Map<String, Object> params = new HashMap<String, Object>();
	        params.put("conds", conds);
	        params.put("offset", page > 0 ? page : 0);
	        params.put("limit", pageSize > 0 ? pageSize : 0);
	        params.put("sort", sort);
			params.put("id",id);
	        return menuMapper.fetchSearchByPageSeach(params);
	}

	@Override
	public int fetchSearchByPageSeachCount(Conds conds,Long id) {
		Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
		params.put("id",id);
        return menuMapper.fetchSearchByPageSeachCount(params);
	}

	@Override
	public int update(Long parentId) {
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("parentId", parentId);
		return menuMapper.updateChild(params);
	}
}
