package com.cftech.member.service;

import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.member.model.MemberTags;
import com.cftech.member.model.TagsCards;

import java.util.List;
import java.util.Map;

/**
 * Service
 *
 * @author lisw
 * @date: 2017-09-13 14:04
 */
public interface MemberTagsService extends GenericService<MemberTags> {


    /**
     * 添加标签，并添加标签与卡券对应关系
     *
     * @param memberTags
     * @return
     */
    public int saveBatchTagCard(MemberTags memberTags, List<TagsCards> tagsCardsList);


    /**
     * 修改标签，并添加标签与卡券对应关系
     *
     * @param memberTags
     * @return
     */
    public int updateBatchTagCard(MemberTags memberTags, List<TagsCards> tagsCardsList);

    /**
     * 查询标签与卡券的关联关系
     */
    List<TagsCards> fetchSearchCardTagsByPage(Map<String, Object> params);


    /**
     *根据卡券名搜索
     *
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<MemberTags> fetchSearchByPage(Conds conds, Sort sort, int page, int pageSize,String name);

    /**
     * 根据标签查询应该发送的卡券，无标签发送默认卡券
     */
    List<String> getMemberTagsCard(String[] tags);

}
