package com.cftech.cos.qcloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import com.cftech.cos.core.CosService;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.request.DelFileRequest;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.util.IOUtils;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by liuling on 2017/5/2.
 */
@Slf4j
public class QcloudStorageService implements CosService {

    public static COSClient getClient(Cosconfig cosconfig) {
        ClientConfig clientConfig = new ClientConfig();
        // 设置bucket所在的区域，比如广州(gz), 天津(tj)
        clientConfig.setRegion(cosconfig.getRegion());
        // 初始化秘钥信息
        Credentials cred = new Credentials(cosconfig.getAppId(), cosconfig.getKeyId(), cosconfig.getKeySecret());
        // 初始化cosClient
        COSClient cosClient = new COSClient(clientConfig, cred);
        return cosClient;
    }

    @Override
    public JSONObject uploadFile(Cosconfig cosconfig, byte[] data, String path) {
        if(!path.startsWith("/")) {
            path = "/"+path;
        }
        COSClient client = getClient(cosconfig);
        log.info("ready to uploadFile: {}", path);
        UploadFileRequest uploadFileRequest = new UploadFileRequest(cosconfig.getBucket(), path ,data);
        String uploadFileRet = client.uploadFile(uploadFileRequest);
        log.info("update File: {}, result: {}", path, uploadFileRet);
        client.shutdown();
        return JSON.parseObject(uploadFileRet);
    }

    @Override
    public JSONObject uploadFile(Cosconfig cosconfig, InputStream inputStream, String path) {
        JSONObject jsonObject = new JSONObject();
        if(!path.startsWith("/")) {
            path = "/"+path;
        }
        try {
            byte[] data = IOUtils.toByteArray(inputStream);
            return uploadFile(cosconfig, data, path);
        } catch (IOException e) {
            log.error(e.getMessage());
            jsonObject.put("code", "1");
            jsonObject.put("message", "trans to byte error");
            return jsonObject;
        }
    }

//    @Override
//    public JSONObject uploadFile(Cosconfig cosconfig, File file, String path) {
//        if(path.startsWith("/")) {
//            path = path.substring(1);
//        }
//        COSClient client = getClient(cosconfig);
//        log.info("ready to uploadFile: {}", path);
//        UploadFileRequest uploadFileRequest = new UploadFileRequest(cosconfig.getBucket(), path, file.getAbsolutePath()+File.separator + file.getName());
//        String uploadFileRet = client.uploadFile(uploadFileRequest);
//        log.info("update File: {}, result: {}", path, uploadFileRet);
//        client.shutdown();
//        return JSON.parseObject(uploadFileRet);
//    }

    @Override
    public JSONObject deleteFile(Cosconfig cosconfig, String cosPath) {
        COSClient client = getClient(cosconfig);
        if(!cosPath.startsWith("/")) {
            cosPath = "/"+cosPath;
        }
        log.info("ready to deleteFile : {}", cosPath);

        DelFileRequest delFileRequest = new DelFileRequest(cosconfig.getBucket(), cosPath);
        String delFileRet = client.delFile(delFileRequest);
        log.info("delete File: {}, result: {}", cosPath, delFileRet);
        client.shutdown();
        return JSON.parseObject(delFileRet);
    }
}
