package com.cftech.cms.distributor.service.impl;

import com.cftech.cms.distributor.model.Distributor;
import com.cftech.cms.distributor.dao.DistributorMapper;
import com.cftech.cms.distributor.model.DistributorDto;
import com.cftech.cms.distributor.service.DistributorService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2019-03-18 16:08
 */
@Service("distributorService")
public class DistributorServiceImpl extends GenericServiceImpl<Distributor> implements DistributorService {

    @Autowired
    @Qualifier("distributorMapper")
    private DistributorMapper distributorMapper;

    @Override
    public GenericDao<Distributor> getGenericMapper() {
        return distributorMapper;
    }

    @Override
    public List<DistributorDto> selectDistributor(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return distributorMapper.selectDistributor(params);
    }

    @Override
    public int selectDistributorCount(Conds conds){
        Map<String,Object> params = new HashMap<>();
        params.put("conds",conds);
        return distributorMapper.selectDistributorCount(params);
    };

    @Override
    public  DistributorDto selectDistributorDetail(Conds conds){
        Map<String,Object> params = new HashMap<>();
        params.put("conds",conds);
        return distributorMapper.selectDistributorDetail(params);
    };

}