package com.cftech.core.util;

import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

/** 
 * @author 作者 lisw: 
 * @version 创建时间：2016年11月30日 下午6:17:52 
 * 类说明 
 */
public class HtmlParserUtils {
	
	/**
	 * 微信素材内容图片必须官方图片，而官方图片外部不能引用（造成后台不能显示）
	 * 故，存两份。群发时将内容中img标签的src替换成微信官方图片
	 * 内容中的src是本地地址，data-src为微信官方地址，将src替换成data-src
	 * @return
	 * @throws ParserException 
	 */
	public static String articleImg(String content) throws ParserException{
		 Parser parser =new Parser(content);
         NodeFilter filter = new TagNameFilter ("img");  //获取所有的img标签  
         NodeList nodes = parser.extractAllNodesThatMatch(filter);
         Node eachNode = null;  
         ImageTag imageTag = null;  
         String oldSrcPath = null;
         String dataSrcPath = null;
         if (nodes != null)  
         {  
             for (int i = 0; i < nodes.size(); i++)   
             {  
                 eachNode = (Node)nodes.elementAt(i);  
                 if (eachNode instanceof ImageTag)   
                 {
                     imageTag = (ImageTag)eachNode;
                     String oldStr=imageTag.toHtml();
                     oldSrcPath = imageTag.getAttribute("src");  //获取src属性
                     dataSrcPath=imageTag.getAttribute("data-src");
                     imageTag.setAttribute("src", dataSrcPath);
                     //imageTag.setAttribute("data-src",oldSrcPath);
                     imageTag.removeAttribute("data-src");
                     String newStr=imageTag.toHtml();
                    content=content.replace(oldStr,newStr);
                 }
             }  
         }
		return content;  
	}
	
	
}
 