package com.cftech.activity.oil.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.log.model.OilLog;
import com.cftech.activity.log.service.OilLogService;
import com.cftech.activity.oil.model.Config;
import com.cftech.activity.oil.model.Oil;
import com.cftech.activity.oil.service.ConfigService;
import com.cftech.activity.oil.service.OilService;
import com.cftech.activity.oil.utils.OilActivityRedisAPI;
import com.cftech.activity.record.model.OilRecord;
import com.cftech.activity.record.service.OilRecordService;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.StringUtils;
import com.cftech.member.model.Member;
import com.cftech.member.service.MemberService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

/**
 * 手机端机油大转盘接口
 * @author wuxf
 * @version 2017-04-27
 */
@RestController
@RequestMapping("/mobile/auth/activity/oil")
@Slf4j
public class MobileOilController {

    @Autowired
    private OilService oilService;

    @Autowired
    private OilLogService oilLogService;

    @Autowired
    private OilActivityRedisAPI redisAPI;

    @Autowired
    private ConfigService configService;

    @Autowired
    private OilRecordService oilRecordService;

    @Autowired
    private MemberService memberService;

    /**
     * 获取机油大转盘活动详情接口
     *
     * @param accountsId
     * @return
     */
    @RequestMapping(value = "/detail/{accountsId}/{openid}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject detail(@PathVariable("accountsId") Long accountsId,@PathVariable("openid") String openid) {
        JSONObject rtnJson = new JSONObject();
        try {
            Conds conds=new Conds();
            conds.equal("accounts_id",accountsId);
            conds.equal("del_flag","0");
            Oil oil = oilService.fetchSearchByConds(conds);
            rtnJson.put("errorNo", 0);
            rtnJson.put("data", oil);
            Conds logConds=new Conds();
            logConds.equal("del_flag","0");
            //logConds.equal("status","0");
            logConds.equal("open_id",openid);
            List<OilLog> logCount=oilLogService.fetchSearchByPage(logConds,null,0,0);
            rtnJson.put("opportunity",logCount);
        } catch (Exception e) {
            log.error("获取活动详情出现异常:" + e.getMessage());
            rtnJson.put("errorNo", 1);
            rtnJson.put("errorMsg","服务器异常");
        }
        return rtnJson;
    }

    @RequestMapping(value = "/play/{accountsId}/{activityId}/{logId}/{openId}/{memberId}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject play(@PathVariable("accountsId") Long accountsId,@PathVariable("activityId") Long activityId, @PathVariable("logId") Long logId,@PathVariable("openId") String openId,@PathVariable("memberId") Long memberId) {
        JSONObject rtnJson = new JSONObject();
        try {
            Oil oil = oilService.fetchById(activityId);
            OilLog oilLog=oilLogService.fetchById(logId);
            oilLog.setAccountsId(accountsId);
            if(oilLog.getStatus().equals("1")){
                rtnJson.put("errorNo","1");
                rtnJson.put("errorMsg","您已参与过抽奖!");
                return rtnJson;
            }
            Conds conConds=new Conds();
            conConds.equal("type",oilLog.getType());
            conConds.equal("del_flag","0");
            Config config=configService.fetchSearchByConds(conConds);
            JSONObject playJson = redisAPI.play(openId,oil,oilLog,config);
            if(playJson.getString("errorNo").equals("0")){
                String str=oil.getPrizes();
                if(StringUtils.isNotBlank(str)){
                    JSONArray arr= JSON.parseArray(str);
                    String prizeCode=playJson.getString("data");
                    for(int i=0,j=arr.size();i<j;i++){
                        JSONObject obj=arr.getJSONObject(i);
                        if(obj.getString("code").equals(prizeCode)){
                            oilLog.setStatus("1");
                            oilLogService.update(oilLog);
                            Member member=memberService.fetchById(memberId);
                            OilRecord record=new OilRecord();
                            record.setAccountsId(accountsId);
                            record.setMemberId(memberId);
                            record.setQuota(obj.getString("amount"));
                            record.setType("0");
                            record.setDescription("机油大转盘");
                            String oilSum="0";
                            if(StringUtils.isNotBlank(member.getOilSum())){
                                oilSum=member.getOilSum();
                            }
                            BigDecimal a = new BigDecimal(oilSum);
                            BigDecimal b = new BigDecimal(obj.getString("amount"));
                            BigDecimal c = a.add(b);
                            member.setOilSum(c.toString());
                            oilRecordService.saveTran(record,member);
                        }
                    }
                }
            }
            rtnJson=playJson;


        } catch (Exception e) {
            rtnJson.put("errorNo",1);
            log.error("玩游戏出现异常:" + e.getMessage());
        }
        return rtnJson;
    }



}
