package com.cftech.sys.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.sys.dao.ExportLogMapper;
import com.cftech.sys.model.ExportLog;
import com.cftech.sys.service.ExportLogService;
import com.cftech.sys.service.SqlHelper;
import com.cftech.sys.util.ExportUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/**
 * logService
 * @author KangLiang Huang
 */
@Service("exportLogService")
public class ExportLogServiceImpl extends GenericServiceImpl<ExportLog> implements ExportLogService {

	@Autowired
	private SqlSessionFactory sqlSessionFactory;

	/**
	 * exportLogMapper
	 */
	@Autowired
	@Qualifier("exportLogMapper")
	private ExportLogMapper exportLogMapper;

	@Override
	public GenericDao<ExportLog> getGenericMapper() {
		return exportLogMapper;
	}

	//获取执行的SQL,分页的调用方式
	@Override
	@Transactional(readOnly = false)
	public void exportRSVPSQL(Conds conds, Sort sort, int page, int pageSize,String nameSpaceWithId,ExportLog exportLog)
	{
		Map<String, Object> parameterMap = new HashMap<String, Object>();
		parameterMap.put("conds", conds);
		parameterMap.put("offset", page > 0 ? page : 0);
		parameterMap.put("limit", pageSize > 0 ? pageSize : 0);
		parameterMap.put("sort", sort);
		Configuration configuration = sqlSessionFactory.getConfiguration();
		BoundSql boundSql = configuration.getMappedStatement(nameSpaceWithId).getBoundSql(parameterMap);
		String sql = ExportUtils.formatSql( boundSql.getSql());
//		List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
		String outSQl = ExportUtils.formatSql(SqlHelper.getMapperSql(configuration,nameSpaceWithId,
				parameterMap).trim());
		ExportUtils.handleLog(exportLog,sql,outSQl,parameterMap);
		exportLogMapper.save(exportLog);
	}

	//获取执行的SQL,简单Map的调用方式
	@Override
	@Transactional(readOnly = false)
	public void exportRSVPSQL(Map<String,Object> parameterMap,String nameSpaceWithId,ExportLog exportLog)
	{
		Configuration configuration = sqlSessionFactory.getConfiguration();
		BoundSql boundSql = configuration.getMappedStatement(nameSpaceWithId).getBoundSql(parameterMap);
		String sql =  ExportUtils.formatSql(boundSql.getSql());
//		List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
		String outSQl =  ExportUtils.formatSql(SqlHelper.getMapperSql(configuration,nameSpaceWithId,
				parameterMap).trim());
		ExportUtils.handleLog(exportLog,sql,outSQl,parameterMap);
		exportLogMapper.save(exportLog);
	}



}
