package com.cftech.common.promotionstock.service.impl;

import com.cftech.common.promotionstock.dao.PromotionStockMapper;
import com.cftech.common.promotionstock.model.*;
import com.cftech.common.promotionstock.service.PromotionStockService;
import com.cftech.common.typeappform.model.TypeAppForm;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lisw
 * @program schaeffler
 * @description 促销品库存业务实现类
 * @createDate 2020-01-12 19:11:15
 **/
@Service
public class PromotionStockServiceImpl extends GenericServiceImpl<PromotionStock> implements PromotionStockService  {

    @Autowired
    private PromotionStockMapper promotionStockMapper;



    @Override
    protected GenericDao<PromotionStock> getGenericMapper() {
        return promotionStockMapper;
    }

    @Override
    public List<PStockStatisticalDto> fetchPStockStatistical(String startDate, String endDate) {
       Map<String,Object> params = new HashMap<>();
       params.put("startDate",startDate);
       params.put("endDate",endDate);
       return promotionStockMapper.fetchPStockStatistical(params);
    }

    @Override
    public List<GrantDetailDto> managerGrantDetail(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.managerGrantDetail(params);
    }

    @Override
    public List<AfterStockDto> managerAfterStock(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.managerAfterStock(params);
    }

    @Override
    public List<GrantDetailDto> supplierGrantDetail(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.supplierGrantDetail(params);
    }

    @Override
    public BigDecimal supplierLogisticsPrice(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.supplierLogisticsPrice(params);
    }

    @Override
    public List<GrantDetailDto> deptGrantDetails(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.deptGrantDetails(params);
    }

    @Override
    public List<GrantDetailDto> useGrantDetails(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.useGrantDetails(params);
    }

    @Override
    public EvalityNumberDto managerEvaluate(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.managerEvaluate(params);
    }

    @Override
    public EvalityNumberDto applyEvaluate(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.applyEvaluate(params);
    }

    @Override
    public Integer managerConfirm(String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        return promotionStockMapper.managerConfirm(params);
    }

    @Override
    public List<TypeAppForm> fetchSearchByPageByAppform(Conds conds, String startDate, String endDate) {
        Map<String,Object> params = new HashMap<>();
        params.put("startDate",startDate);
        params.put("endDate",endDate);
        params.put("conds",conds);
        return promotionStockMapper.fetchSearchByPageByAppform(params);
    }

    @Override
    public List<SupplierStockDto> getSupplierStockStatistics(Map<String, Object> params) {
        return promotionStockMapper.getSupplierStockStatistics(params);
    }
}
