package com.cftech.questionnaire.core.papercategory.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;
import org.springframework.data.annotation.Transient;

import java.io.Serializable;
import java.util.Date;

/**
 * 问卷分类
 *
 * @author Neil
 * @date: 2017-05-23 13:24
 */
@Data
public class Papercategory implements Serializable {

    /* 主键id */
    private Long id;
    /* 分类名称 */
    @ExportConfig(value = "分类名称", width = 100)
    private String name;
    /**
     * 上级分类
     */
    private Long parentId;

    /**
     * 上级分类名称
     */
    @Transient
    private String parentName;

    /**
     * 上级分类顺序ids
     */
    private String parentIds;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Papercategory() {
        this.delFlag = false;
        this.status = "0";
    }

}