var UserList = function () {

    var initTable = function () {

        var table = $('#userlilst');
        var pageSize = 10;

        var formattime = function(times, fmt) {
            var date = new Date(times);
            var o = {
                "M+": date.getMonth() + 1, //月份
                "d+": date.getDate(), //日
                "h+": date.getHours(), //小时
                "m+": date.getMinutes(), //分
                "s+": date.getSeconds(), //秒
                "q+": Math.floor((date.getMonth() + 3) / 3), //季度
                "S": date.getMilliseconds() //毫秒
            };
            if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
            for (var k in o)
                if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            return fmt;

        };

        var retrieveData = function (sSource, aoData, fnCallback) {

            $.ajax({
                "type": "GET",
                "contentType": "application/json",
                "url": sSource,
                "dataType": "json",
                "data": aoData, //以json格式传递
                "success": fnCallback
            });
        };

        // begin first table
        table.dataTable({

            // Internationalisation. For more info refer to http://datatables.net/manual/i18n
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "bFiltered": false,
            // Or you can use remote translation file
            "oLanguage": {                          //汉化
                "sLengthMenu": "每页显示 _MENU_ 条记录",
                "sZeroRecords": "没有检索到数据",
                "sInfo": "当前数据为从第 _START_ 到第 _END_ 条数据；总共有 _TOTAL_ 条记录",
                "sInfoEmtpy": "没有数据",
                "sInfoFiltered": "(从 _MAX_ 条数据中检索)",
                "sProcessing": "正在加载数据...",
                "oPaginate": {
                    "sFirst": "首页",
                    "sPrevious": "前页",
                    "sNext": "后页",
                    "sLast": "尾页"
                }
            },
            "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
            "bProcessing": true,
            "bServerSide": true,
            "sAjaxSource": "userlist/fetchdata",
            "iDisplayLength": pageSize,
            "fnServerData": retrieveData,
            "pagingType": "full_numbers",
            "aoColumns": [
                {"mData": "id"},
                {"mData": "username"},
                {"mData": "password"},
                {"mData": "state"}],
            "aoColumnDefs": [
                {  // set default column settings
                    'visible': false,
                    'targets': [0]
                },
                {
                    "aTargets": [4],
                    "mData": "createtime",
                    "mRender": function (a, b, c, d) {//a表示createtime对应的值，c表示当前记录行对象
                        return formattime(a.time,"yyyy-MM-dd hh:mm:ss");
                    }
                },
                {
                    "aTargets": [5],
                    "mData": "id",
                    "mRender": function (a, b, c, d) {//a表示id对应的值，c表示当前记录行对象
                        var viewHTML = '<a href="#" data-id="'+a+'" data-action="view" class="btn green">查看</a>';
                        var removeHTML = '<a href="#" data-id="'+a+'" data-action="remove" class="btn red">删除</a>';
                        return viewHTML+removeHTML;
                    }
                }
            ]
        });

    };

    return {

        //main function to initiate the module
        init: function () {
            if (!jQuery().dataTable) {
                return;
            }

            initTable();
        }

    };

}();