package com.cftech.member.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.member.dao.MemberTagsMapper;
import com.cftech.member.model.MemberTags;
import com.cftech.member.model.TagsCards;
import com.cftech.member.service.MemberTagsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author lisw
 * @date: 2017-09-13 14:04
 */
@Service("memberTagsService")
public class MemberTagsServiceImpl extends GenericServiceImpl<MemberTags> implements MemberTagsService {

    @Autowired
    @Qualifier("memberTagsMapper")
    private MemberTagsMapper memberTagsMapper;

    @Override
    public GenericDao<MemberTags> getGenericMapper() {
        return memberTagsMapper;
    }

    @Override
    public int saveBatchTagCard(MemberTags memberTags, List<TagsCards> tagsCardsList) {
        try{
            memberTagsMapper.save(memberTags);
            Map<String,Object> params = new HashMap<String,Object>();
            params.put("tagCards",tagsCardsList);
            params.put("tagsId",memberTags.getId());
            memberTagsMapper.saveBatchTagsCard(params);
            return 0;
        }catch (Exception e){
            e.printStackTrace();
        }
       return 1;
    }

    @Override
    public int updateBatchTagCard(MemberTags memberTags, List<TagsCards> tagsCardsList) {
            Map<String,Object> delParams = new HashMap<String,Object>();
            delParams.put("tagId",memberTags.getId());
            memberTagsMapper.delTagCard(delParams);
            memberTagsMapper.update(memberTags);
            Map<String,Object> params = new HashMap<String,Object>();
            params.put("tagCards",tagsCardsList);
            params.put("tagsId",memberTags.getId());
            memberTagsMapper.saveBatchTagsCard(params);
            return 0;
    }

    @Override
    public List<TagsCards> fetchSearchCardTagsByPage(Map<String, Object> params) {
        return memberTagsMapper.fetchSearchCardTagsByPage(params);
    }

    @Override
    public List<MemberTags> fetchSearchByPage(Conds conds, Sort sort, int page, int pageSize, String name) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return memberTagsMapper.fetchSearchByPage(params);
    }

    @Override
    public List<String> getMemberTagsCard(String[] tags) {
        Map<String,Object> params = new HashMap<String,Object>();
        params.put("tags",tags);
        return memberTagsMapper.getMemberTagsCard(params);
    }
}