package com.cftech.base.codingrule.service.impl;

import com.cftech.base.codingrule.dao.CodingruleMapper;
import com.cftech.base.codingrule.model.Codingrule;
import com.cftech.base.codingrule.service.CodingruleService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * codingruleService
 * Created by Neil 16/02/2017.
 */
@Service("codingruleService")
public class CodingruleServiceImpl extends GenericServiceImpl<Codingrule> implements CodingruleService {

    /**
     * codingruleMapper
     */
    @Autowired
    @Qualifier("codingruleMapper")
    private CodingruleMapper codingruleMapper;

    @Override
    public GenericDao<Codingrule> getGenericMapper() {
        return codingruleMapper;
    }


    @Override
    public Codingrule findByAccountsIdAndBo(Long accountsId, String bo) {
        Conds myCond = new Conds();
        myCond.equal("del_flag", Constants.DEL_FLAG_0);
        myCond.equal("status", "0");
        myCond.equal("accounts_id", accountsId);
        myCond.equal("bo", bo);

        return fetchSearchByConds(myCond);
    }
}
