package com.cftech.cms.email_record.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.SendEmail.EmailSenderWithAttach;
import com.cftech.cms.SendEmail.MailBean;
import com.cftech.cms.SendEmail.ZipUtils;
import com.cftech.cms.email_record.model.Email_record;
import com.cftech.cms.email_record.service.Email_recordService;
import com.cftech.cms.exhibi.model.Exhibi;
import com.cftech.cms.exhibi.service.ExhibiService;
import com.cftech.cms.exhibi_material.model.Exhibi_material;
import com.cftech.cms.exhibi_material.service.Exhibi_materialService;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.SystemConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/mobile/auth/emailrecord")
public class MobileEmail_recordController {

    @Autowired
    private Email_recordService email_recordService;
    @Autowired
    private Exhibi_materialService exhibi_materialService;
    @Autowired
    private ExhibiService exhibiService;

    /**
     * 发送邮箱记录
     * @param exhibi_id 展会ID
     * @param email 邮箱
     * @param open_id 用户OPENID
     * @param sample_id 发送资料的ID
     * @param send_count 发送了多少条
     * @param accounts_id
     * @return
     */
    @RequestMapping(value = "/addEmailRecord" ,method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject addEmailRecord(@RequestParam Long exhibi_id,@RequestParam String email,@RequestParam String open_id ,@RequestParam String sample_id,
    @RequestParam Long send_count,@RequestParam Long accounts_id,@RequestParam String name){
        JSONObject jsonObject = new JSONObject();
        try {
            String[] str = sample_id.split(",");
            Conds conds = new Conds();
            conds.equal("del_flag",0);
            conds.in("id",str);
            List<Exhibi_material> list = exhibi_materialService.fetchSearchByPage(conds,null,0,0);
          // File zipPath = ZipUtils.toZip(list);
            MailBean mb = new MailBean();
            mb.setHost(SystemConfig.p.getProperty("email.host"));
            mb.setUsername(SystemConfig.p.getProperty("email.username"));
            mb.setPassword(SystemConfig.p.getProperty("email.password"));
            mb.setFrom(SystemConfig.p.getProperty("email.from"));
            mb.setTo(email);
            Exhibi exhibi = exhibiService.fetchById(exhibi_id);
            mb.setSubject(exhibi.getExhibi_title()+"_样本资料");
            StringBuffer sb = new StringBuffer();
            sb.append("Dear Mr./ Ms."+name+"<br/><br/>");
            sb.append("感谢您参观舍弗勒展台！请点击下载您所需的产品样本资料<br/>");
            sb.append("Thanks for visiting Schaeffler booth! Please click and download the product publications as below:<br/>");
            for(Exhibi_material ex : list){
                sb.append("<a href='"+ex.getFile_path()+"'>"+ex.getMaterial_name()+"</a><br/>");
            }
            sb.append("<br/><span style='font-size:10px; color:#C0C0C0;'>因文件太大，若无法直接打开，建议您使用电脑下载。</span><br/>");
            sb.append("<span style='font-size:10px; color:#C0C0C0;'>If the file is too big to open, please try to download on your computer.</span><br>");
            sb.append("<br/>Best Regards,<br/>");
            sb.append("Schaeffler<br/>");
            mb.setContent(sb.toString());
            mb.setFilename("展会资料附件.zip");
            List<File> files = new ArrayList<File>();
            String [] results = EmailSenderWithAttach.sendAttachEmail(mb.getHost(),
                    mb.getFrom(),mb.getTo(),mb.getSubject(),mb.getContent(),files,mb.getUsername(),mb.getPassword(),"465",mb.getFilename());
            if(results!=null && "0".equals(results[0])){
                //邮件发送成功
                Email_record email_record = new Email_record();
                email_record.setExhibi_id(exhibi_id);
                email_record.setEmail(email);
                email_record.setOpen_id(open_id);
                email_record.setAccountsId(accounts_id);
                email_record.setSample_id(sample_id);
                email_record.setSend_count(send_count);
                email_recordService.save(email_record);
                jsonObject.put("errorNo",0);
            }else{
                jsonObject.put("error",results);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);

        }
        return jsonObject;
    }

}
