package com.cftech.sys.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.core.mongo.Pager;
import com.cftech.core.util.DateUtils;
import com.cftech.core.util.ExcelUtils;
import com.cftech.core.util.JsonDateValueProcessor;
import com.cftech.sys.model.MobileLog;
import com.cftech.sys.param.SysLogListParam;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import com.cftech.sys.service.MobileLogService;
import com.cftech.sys.service.MobileViewlogService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * @author 作者 lisw: 
 * @version 创建时间：2016年10月24日 下午1:34:10 
 * 后台日志操作Controller
 */
@Controller
@RequestMapping("/a/mobileviewlog")
public class MobileViewLogController {

	@Autowired
	private MobileViewlogService mobileViewlogService;

	@Autowired
	private MobileLogService mobileLogService;

	@Autowired
	private MpAccountsService mpAccountsService;

	//访问日志
	@RequestMapping(value="/list",method=RequestMethod.GET)
	@RequiresPermissions(value = PermissionSign.SYSLOG_VIEWS)
	public String sysLogList(HttpServletRequest request,SysLogListParam sysLogListParam,Model model){
		model.addAttribute("sysLogListParam",sysLogListParam);
		return "managerlog/mobileviewloglist";
	}

	//操作日志
	@RequestMapping(value="/listStatic",method=RequestMethod.GET)
	@RequiresPermissions(value = PermissionSign.SYSLOG_VIEWS)
	public String sysLogListStatic(HttpServletRequest request,SysLogListParam sysLogListParam,Model model){
		model.addAttribute("sysLogListParam",sysLogListParam);
		return "managerlog/mobileloglist";
	}

	@RequestMapping(value="/fetchData",method=RequestMethod.GET)
	@RequiresPermissions(value = PermissionSign.SYSLOG_VIEWS)
	@ResponseBody
	public JSONObject fetchData(int iDisplayStart, int iDisplayLength,
													 MobileLog log, SysLogListParam sysLogListParam, HttpServletRequest request){

//		Sort sort = new Sort("t.create_date", OrderType.DESC);
//		Conds conds = new Conds();
//		//请求参数
//		if(sysLogListParam != null){
//			if(StringUtils.isNoneBlank(sysLogListParam.getBrithdayStarttime()) && StringUtils.isNoneBlank(sysLogListParam.getBrithdayEndtime())){
//				conds.between("t.create_date", sysLogListParam.getBrithdayStarttime(),sysLogListParam.getBrithdayEndtime());
//			}else if(StringUtils.isNoneBlank(sysLogListParam.getBrithdayStarttime())){
//				conds.greatEqual("t.create_date",sysLogListParam.getBrithdayStarttime());
//			}else if(StringUtils.isNoneBlank(sysLogListParam.getBrithdayEndtime())){
//				conds.lessEqual("t.create_date",sysLogListParam.getBrithdayEndtime());
//			}
//		}
//		// 获取列表数据
//		List<MobileViewlog> activityList = mobileViewlogService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
//		// 获得总数
//		Integer userCounts = mobileViewlogService.count(conds);
		MpAccountsEntity account =mpAccountsService.getDetail(UserUtils.getmpaccounts(request));
		log.setAppid(account.getAppid());
		Pager pager = new Pager();
		pager.setPageNum(iDisplayStart/iDisplayLength);
		pager.setPageSize(iDisplayLength);
		Pager page =mobileLogService.selectPage(log, pager);
//		if(page!=null && page.getResult()!=null && page.getResult().size()>0){
//			List<MobileLog> logs = page.getResult();
//			for(MobileLog mobile : logs){
//				System.out.println(mobile.getOpenid());
//			}
//		}else{
//			System.out.println("未查询到数据");
//		}
		JSONObject rtnJson = new JSONObject();
		rtnJson.put("iTotalRecords", page.getTotal());
		rtnJson.put("iTotalDisplayRecords", page.getTotal());
		rtnJson.put("aaData", page.getResult());
		return rtnJson;
	}

	@RequestMapping("/export")
	public void export(MobileLog log,SysLogListParam sysLogListParam,HttpServletRequest request,HttpServletResponse response){
		MpAccountsEntity account = mpAccountsService.getDetail(UserUtils.getmpaccounts(request));
		log.setAppid(account.getAppid());
		Pager pager = new Pager();
		pager.setPageNum(0);
		pager.setPageSize(50000);
		Pager page =mobileLogService.selectPage(log, pager);
		List list = page.getResult();
//		if(page.getTotal()>50000){//仅截取50000条
//			list=list.subList(0, 49999);
//		}
		// 参数
		try {
				ExcelUtils.export(request, response,"访问日志报表-" + DateUtils.formatDate(new Date(), "yyyy-MM-dd"),list, "logview");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}



	//清空前端访问日志
	@RequestMapping(value="/deleteAllMobileViewLog",method=RequestMethod.POST)
	@ResponseBody
	public JSONObject deleteAllMobileLog(){
		JSONObject rtnJson = new JSONObject();
		rtnJson.put("errorNo", 0);
		try {
			mobileViewlogService.deleteAllMobileViewLog();
		} catch (Exception e) {
			rtnJson.put("errorNo", 1);
		}
		return rtnJson;
	}
}
 